    //*********************************************************************
 //  Aei؂ւ@PIC16F819   Disp = ACM1602 Type
 //                            CYTEC    2026/01-11
 //    pqo@POv^Cv
 //    2026/01-11  Jn
 //    2026/01-29  
 //**********************************************************************

//******   vg^Cv錾 *********************************************
//--- LCD ------
 void main();
 void await(unsigned long ct);
 void start();
 void stop();
 void wr_Byte(unsigned char x);
 void cmd_LCD(unsigned char x);
 void LCD_str(unsigned char *s);
 void LCD_Pos(unsigned char keta,unsigned char gyou);
 void LCD_ini();
 void PIC16F819_set();
 void buzz();
 void rig_switch_check();
 void ant_switch_check();
 void Start_set();


//******  O-oϐ錾 ********************************************

  unsigned char   Rig_flag;     // 0x01 = Rig(A), 0x02 = Rig(B)
  unsigned char   Ant_flag;     // 0x03 = Ant(A), 0x02 = Ant(B), 0x01 = Ant(C)
  unsigned char   oldstate;
  
//******  Selected destination Text  ***********************************

 unsigned char  RIG_A[] = "Orion-406";       //Kvɍ킹ď
 unsigned char  RIG_B[] = "Milkeyway";       //Kvɍ킹ď
 unsigned char  ANT_A[] = "5Band_ANT";       //Kvɍ킹ď
 unsigned char  ANT_B[] = "7MHz_DP";         //Kvɍ킹ď
 unsigned char  ANT_C[] = "Reserve";         //Kvɍ킹ď
 
 

//****** sATC *************************************************

  #define SCL    PORTB.F4    //I2C Clock
  #define SDA    PORTB.F5    //I2C Data
  
  #define Sound  PORTB.B6    //Buzza

//****** 錾@*********************************************************

  #define  LCD_AD   0xA0     //ACM1602N1

//******************************************************************************
//  Main@
//******************************************************************************

void main()
{
    PIC16F819_set();
    LCD_ini();

    Start_set();

   while(1)
      {
       rig_switch_check();
       Delay_ms(10);
       ant_switch_check();
       Delay_ms(10);

      }
}

//******************************************************************************
// Start Seting  ANT&RIG 
//******************************************************************************
void Start_set()
 {
// ANT Set
            PORTA.B7 = 0;             //ANT = (A)
            PORTA.B6 = 0;
            Ant_flag = 0x03;
            LCD_pos(1,1);
            LCD_str("ANT-A: ");
            LCD_pos(1,8);
            LCD_str(ANT_A);

// Rig_Set
            PORTA.B0 = 0;                //Rig = (A)
            Rig_flag = 0x02;
            LCD_pos(2,1);
            LCD_str("RIG-A: ");
            LCD_pos(2,8);
            LCD_str(RIG_A);
 }
 
//******************************************************************************
// RIG Switch_Check 
//     Relay ON = 1, OFF = 0
//******************************************************************************

 void rig_switch_check()
{
     if(Button(&PORTB,1,20,1)) oldstate = 1;
     if(oldstate && Button(&PORTB,1,20,0))
    {
    
       LCD_pos(2,7);
       LCD_str("           ");

       if(Rig_flag == 0x02)           //RIG(B)
          {
            buzz();
            PORTA.B0 = 1;
            Rig_flag = 0x01;
            LCD_pos(2,1);
            LCD_str("RIG-B: ");
            LCD_pos(2,8);
            LCD_str(RIG_B);
            oldstate = 0;
            return;
          }

       if(Rig_flag == 0x01)             //RIG(A)
          {
            buzz();
            PORTA.B0 = 0;
            Rig_flag = 0x02;
            LCD_pos(2,1);
            LCD_str("RIG-A: ");
            LCD_pos(2,8);
            LCD_str(RIG_A);
            oldstate = 0;
            return;
          }
    }
}

//******************************************************************************
// ANT Switch_Check 
//     Relay ON = 1, OFF = 0
//******************************************************************************
void ant_switch_check()
 {
    if(Button(&PORTB,0,20,1)) oldstate = 1;
    if(oldstate && Button(&PORTB,0,20,0))
    {
      if(PORTB.B0 == 0)
       {
          Ant_flag -= 1;
          if(Ant_flag == 0)  Ant_flag = 0x03;
          oldstate = 0;
          
          LCD_pos(1,6);
          LCD_str("           ");
          
           if(Ant_flag == 0x03)
               {
                  buzz();
                  PORTA.B7 = 0;             //ANT = (A)
                  PORTA.B6 = 0;
                  LCD_pos(1,1);
                  LCD_str("ANT-A: ");
                  LCD_pos(1,8);
                  LCD_str(ANT_A);
                }
               
            if(Ant_flag == 0x02)
               {
                  buzz();
                  PORTA.B7 = 1;             //ANT = (B)
                  PORTA.B6 = 0;
                  LCD_pos(1,1);
                  LCD_str("ANT-B: ");
                  LCD_pos(1,8);
                  LCD_str(ANT_B);
               }

            if(Ant_flag == 0x01)
               {
                  buzz();
                  PORTA.B7 = 1;             //ANT = (C)
                  PORTA.B6 = 1;
//                  LCD_pos(2,6);
//                  LCD_str("           ");
                  LCD_pos(1,1);
                  LCD_str("ANT-C: ");
                  LCD_pos(1,8);
                  LCD_str(ANT_C);
                  oldstate=0;
               }
        }
     }
  }

//******************************************************************************
//  PIC16F819 @
//******************************************************************************
void PIC16F819_set()            // NO WeekPull
{
     OSCCON     = 0b01110100;   // NbN8lgƂ

     ADCON1     = 0b00000110;   //RA0-RA4 fW^[qɐݒ肷

     OPTION_REG.F7 = 0;         //onqsavAbvB 0=Pull-Up

     TRISA      = 0b00000000;   // o͐ݒ@0=OUTPUT  1=INPUT
     TRISB      = 0b00000111;

     PORTA      = 0b00000000;   // o̓s̏(SLOWɂ)
     PORTB      = 0b00000000;
}

//******************************************************************************
// Wate Timer@
//******************************************************************************
 void await(unsigned long ct)
{
  while(ct>0) ct--;
}

//******************************************************************************
// ACM_I2C Start@
//******************************************************************************
//  I2C LCD  ACM1602
void start()
{
    SCL = 1;                            // start condition
    await(3);
    SDA = 1;
    await(3);
    SDA = 0;
    await(3);
    SCL = 0;
    await(3);
 }

//******************************************************************************
// ACM_I2C Stop@
//******************************************************************************
//  I2C LCD  ACM1602
void stop()
{
    await(3);
    SCL = 1;                            // stop condition
    await(3);
    SDA = 0;
    await(3);
    SDA = 1;
    await(3);
    SCL = 0;
    await(3);
 }

//******************************************************************************
// hQb 8bit Data ݁@
//******************************************************************************
void wr_Byte(unsigned char x)
{
    unsigned int k;
    for(k=0;k<8;k++){
        if(x & 0x80) SDA = 1; else SDA = 0;
        await(3);
        SCL = 1;
        await(3);
        SCL = 0;
        await(3);
        SDA = 0;
        x <<= 1;
    }
    SCL = 1;
    await(3);
    SCL = 0;
}

//*****************************************************************************
// kbc@ ݁@
//    `blPUOQ@`O`O
//*****************************************************************************
void cmd_LCD(unsigned char x)
{
    start();

    wr_Byte(LCD_AD);                     //kbcAhX@0xa0
    wr_Byte(0x00);                     //RS Flag Cmd Write (0x00000000)
    wr_Byte(x);

    stop();
}

//***** ACM1602  ***************************************************************
// kbc c \ uv@
//  LCD_str֐̎g
//     LCD_str(call);           z̕\   unsigned char call[]={"JE1AHW"};
//     LCD_str("JE1AHW Kuki");  w\
//******************************************************************************
void LCD_str(unsigned char *s)
{

  while(*s)
    {

    start();
    wr_Byte(LCD_AD);                       //kbcAhX   0xa0
    wr_Byte(0b10000000);                 //R}hf|^   0b10000000 0x80

    wr_Byte(*s);                         //\B
      *s++;

    stop();

    }
}

//*****************************************************************************
// kbc \|WV@
// \AhX   8moji
// 0x00,0x01,0x02-0x07,--,0x0A,0x0B,--0x0F  16moji
// 0x40,0x41,0x42-0x47,--,0x4A,0x4B,--0x4F
//******************************************************************************

void LCD_Pos(unsigned char keta,unsigned char gyou)
{
   unsigned char tmp;

   if(keta == 1) tmp=0;
   if(keta == 2) tmp = 0x40;
    tmp = tmp+(gyou-1);
    tmp=tmp|0x80;
    cmd_LCD(tmp);
 }

//*****  ACM1602  **************************************************************
// kbc imQj@
// gpkbc@@`blPUOQmPiQbj
// akzCg@@^kbc
//******************************************************************************
void LCD_ini()
{
  cmd_LCD(0x38);   //@\FW|hAQCATWhbg
  await(10);

  cmd_LCD(0x0C);   //fBXv|nmAJ|\OFFCuNOFF
  await(10);

  cmd_LCD(0x06);   //J|\ړAXN|nee
  await(10);

}

//******************************************************************************
// uU| 1 
//******************************************************************************
void buzz()
 {
        unsigned char K;
           for(K=0;K<200;K++){                //uU|i^Cvj
           Sound = 1;
           Delay_us(90);
           Sound = 0;
           Delay_us(90);
           }
 }
 
//*********** END **************************************************************